<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\Designation;
use Illuminate\Http\JsonResponse;

class ContactApiController extends Controller
{
    public function pageData($id): JsonResponse
    {
        $conference = Conference::with(['mediaPartners'])->find($id);

        if (!$conference) {
            return response()->json([
                'error' => 'Conference not found'
            ], 404);
        }

        $designations = Designation::orderBy('status')->get();

        return response()->json([
            'designations' => $designations,
            'mediaPartners' => $conference->mediaPartners,
        ]);
    }
}