<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\PreviousProgram;
use App\Models\Brochure;
use Illuminate\Http\JsonResponse;

class ConferenceBookApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with(['ConferenceBookmetaData'])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        // Current Programs (page_type = 4)
        $currentPrograms = Brochure::where([
            'conference_id' => $id,
            'page_type' => 4,
            'status' => 1
        ])
        ->orderBy('id', 'ASC')
        ->get();

        // Previous Programs
        $previousPrograms = PreviousProgram::with('previousConference')
            ->where([
                'conference_id' => $id,
                'status' => 1
            ])
            ->orderBy('conference_year', 'DESC')
            ->get();

        $cmsInfo = $previousPrograms->map(function ($prev) {
            $prevConf = $prev->previousConference;
            $program = $prevConf ? Brochure::where([
                'conference_id' => $prev->previous_conference_id,
                'page_type' => 3, // Previous program
                'status' => 1
            ])
            ->orderBy('id', 'DESC')
            ->first() : null;

            return [
                'id' => $prev->id,
                'previous_conference_id' => $prev->previous_conference_id,
                'conference_year' => $prev->conference_year,
                'prevConferenceInfo' => $prevConf,
                'programInfo' => $program, // pdf_url auto-appended via accessor
            ];
        });

        $meta = $conference->ConferenceBookmetaData;

        return response()->json([
            'success' => true,
            'conferenceBookData' => [
                'currentPrograms' => $currentPrograms,
                'cmsInfo' => $cmsInfo
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Conference Book – Conference',
                'description' => $meta?->meta_description ?? 'Explore current and past conference programs.',
                'keywords' => $meta?->meta_keywords ?? 'conference book, programs, brochures'
            ]
        ]);
    }
}