<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class CommonApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with([
            'headerContent',
            'navigations',
            'socialLinks',
            'address',
            'CommonmetaData' // Will filter by page_type later
        ])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        // 🚫 Fix: Define $page_type (e.g., default to 1 or pass as parameter)
        $pageType = 1; // <-- You can make this dynamic if needed
        $meta = $conference->CommonmetaData->where('page_type', $pageType)->first();

        return response()->json([
            'success' => true,
            'conferenceInfo' => $conference,
            'headercontent' => $conference->headerContent,
            'headerNavigation' => $this->getHeaderNavigation($conference),
            'footerQuickLinks' => $conference->navigations
                ->where('page_type', 2)
                ->where('status', 1)
                ->sortBy('orderpos'),
            'footerUsefulLinks' => $conference->navigations
                ->where('page_type', 3)
                ->where('status', 1)
                ->sortBy('orderpos'),
            'socialLinks' => $conference->socialLinks,
            'mainaddress' => \DB::table('web_cms')->where('page_type', 10)->where('status', 1)->first(),
            'contactInfo' => $conference->address,
            'whatsappNumber' => $conference->address->whatsapp_number,
            'gkey' => $conference->gkey,
            'meta' => [
                'title' => $meta->meta_title ?? $meta->title ?? '',
                'description' => $meta->meta_description ?? '',
                'keywords' => $meta->meta_keywords ?? ''
            ],
            'favicon' => $conference->fav_icon ?? ''
        ]);
    }

    private function getHeaderNavigation(Conference $conference)
    {
        return $conference->navigations
            ->where('page_type', 1)
            ->where('status', 1)
            ->where('parent_id', 0)
            ->sortBy('orderpos')
            ->map(function ($item) use ($conference) {
                $item->headerSubNav = $conference->navigations
                    ->where('parent_id', $item->id)
                    ->where('status', 1)
                    ->sortBy('orderpos');
                return $item;
            });
    }
}