<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sponsor extends Model
{
    protected $table = 'c_sponsors';
    public $timestamps = false;

    protected $appends = ['logo_url', 'profile_url'];

    public function getLogoUrlAttribute()
    {
        if ($this->logo && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->logo);
        }
        return null;
    }

    public function getProfileUrlAttribute()
    {
        return "/exhibitors-sponsors/{$this->alias_title}";
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}