<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegistrationCategory extends Model
{
    protected $table = 'c_registration_categories';
    public $timestamps = false;

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function amounts()
    {
        return $this->hasMany(RegistrationAmount::class, 'category_id');
    }

    public function addonAmounts()
    {
        return $this->hasMany(AddonAmount::class, 'category_id');
    }
}