<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProgramSpeaker extends Model
{
    protected $table = 'c_program_speakers';
    public $timestamps = false;

    protected $appends = ['photo_url'];

    public function getPhotoUrlAttribute()
    {
        if ($this->speaker_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->speaker_img);
        }
        return null;
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function programContent()
    {
        return $this->hasMany(ProgramContent::class, 'c_program_id');
    }
}