<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PreviousSpeaker extends Model
{
    protected $table = 'c_previous_speakers';
    public $timestamps = false;

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function previousConference()
    {
        return $this->belongsTo(Conference::class, 'previous_conference_id');
    }
    
     public function speakers()
    {
        return $this->hasMany(Cspeaker::class, 'conference_id')
                ->where('speaker_type', $this->speaker_type)
                ->where('status', 1)
                ->orderBy('orderpos', 'ASC');
    }
}