<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Conference extends Model
{
    protected $table = 'conferences';
    public $timestamps = false;

    // ... other existing relationships ...

    /**
     * Get the about us items for the conference.
     */
public function aboutUsItems()
{
    return $this->hasMany(AboutUs::class, 'conference_id')
                ->where('status', 1)
                ->orderBy('id', 'ASC');
}

public function AboutmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')
                ->where('page_type', 29); // About Us page type
}


// In app/Models/Conference.php

public function brochures()
{
    return $this->hasMany(Brochure::class, 'conference_id');
}

public function sessionTracks()
{
    return $this->hasMany(SessionTrack::class, 'conference_id')->where('status', 1)->orderBy('orderpos', 'ASC');
}
 public function faqs()
    {
        return $this->hasMany(VenueFaq::class, 'conference_id'); 
        // adjust 'conference_id' if your foreign key column is different
    }
public function headerContent()
{
    return $this->hasOne(HeaderContent::class, 'conference_id');
}

public function navigations()
{
    return $this->hasMany(PageNavigation::class, 'conference_id');
}

public function socialLinks()
{
    return $this->hasMany(SocialLink::class, 'conference_id');
}

public function address()
{
    return $this->hasOne(Address::class, 'conference_id');
}

public function AbstractmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 14); // Abstract Submission page
}

public function registrations()
{
    return $this->hasMany(Registration::class, 'conference_id');
}


// In app/Models/Conference.php

public function speakers()
{
    return $this->hasMany(Speaker::class, 'conference_id');
}

public function banners()
{
    return $this->hasMany(Banner::class, 'conference_id');
}

public function AllSpeakersmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 24); // All Speakers page
}

// In app/Models/Conference.php



public function BrochuremetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 3); // Brochure page
}
// In app/Models/Conference.php

public function CallForPapersmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 4); // Call for Papers page
}
// In app/Models/Conference.php

public function CommonmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id'); // No page_type filter — will be filtered in controller
}
// In app/Models/Conference.php

public function sponsors()
{
    return $this->hasMany(Sponsor::class, 'conference_id')->where('page_type', 1);
}

public function designations()
{
    return $this->hasMany(Designation::class); // Assuming global table, adjust if needed
}

// In app/Models/Conference.php

public function ConferenceBookmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 5); // Conference Book page
}

// In app/Models/Conference.php

public function ConferenceGallerymetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 26); // Gallery page
}

// In app/Models/Conference.php

public function mediaPartners()
{
    return $this->hasMany(Sponsor::class, 'conference_id')
                ->where('page_type', 2)
                ->where('status', 1)
                ->orderBy('id', 'DESC');
}

// In app/Models/Conference.php

public function registrationDates()
{
    return $this->hasOne(RegistrationDate::class, 'conference_id');
}

public function groupRegistrationAmounts()
{
    return $this->hasMany(GroupRegistrationAmount::class, 'conference_id');
}

public function onsiteRegistrationStatus()
{
    return $this->hasOne(OnsiteRegistrationStatus::class, 'conference_id');
}

// In app/Models/Conference.php

public function MediaPartnersmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 32); // Media Partner Detail page
}
public function GroupmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 21); // Group Registration page
}
public function OnlinemetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 11); // Online Registration page
}
// In app/Models/Conference.php

public function PresentationmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 14); // Presentation Submission page
}

public function abstractContent()
{
    return $this->hasMany(AbstractContent::class, 'conference_id')
                ->where('page_type', 5)
                ->where('status', 1)
                ->orderBy('id', 'ASC');
}
// In app/Models/Conference.php


public function previousSpeakersMapping()
{
    return $this->hasMany(PreviousSpeaker::class, 'conference_id')
                ->where('status', 1)
                ->orderBy('orderpos', 'ASC');
}
// In app/Models/Conference.php

public function ProgramDetailsmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 2); // Program Details page
}


// In app/Models/Conference.php

public function ProgramSchedulemetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 5); // Program Schedule page
}

public function previousPrograms()
{
    return $this->hasMany(PreviousProgram::class, 'conference_id')
                ->where('status', 1)
                ->orderBy('conference_year', 'DESC');
}
// In app/Models/Conference.php

public function RegistrationmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 5); // Registration page
}


public function registrationCategories()
{
    return $this->hasMany(RegistrationCategory::class)->where('status', 1);
}

public function addonCategories()
{
    return $this->hasMany(RegistrationCategory::class)->where('page_type', 2)->where('status', 1);
}



public function settings()
{
    return $this->hasOne(Setting::class, 'conference_id');
}

public function registrationContent()
{
    return $this->hasMany(RegistrationContent::class, 'conference_id');
}


// In app/Models/Conference.php

public function ScientificCommitteemetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 8); // Scientific Committee page
}

public function scientificCommitteeSpeakers()
{
    return $this->hasMany(Cspeaker::class, 'conference_id')
                ->where('speaker_type', 1)
                ->where('status', 1)
                ->orderBy('orderpos', 'ASC');
}
// In app/Models/Conference.php

public function ScientificProgrammetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 2); // Scientific Program page
}
// In app/Models/Conference.php

public function SpeakerDetailsmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id', 'conference_id')
        ->where('page_type', 28);
}


// In app/Models/Conference.php

public function SpeakersListmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id');
}

// In app/Models/Conference.php

public function SpeakersPagemetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id');
}


// In app/Models/Conference.php

public function SponsorsExhibitorsmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 12); // Sponsors & Exhibitors page
}

public function sponsorsContent()
{
    return $this->hasMany(SponsorsContent::class, 'conference_id')->orderBy('id', 'ASC');
}

public function exhibitorsContent()
{
    return $this->hasMany(ExhibitorsContent::class, 'conference_id')->orderBy('id', 'ASC');
}

// In app/Models/Conference.php

public function SponsorshipmetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 33); // Sponsorship page
}

public function sponsorshipBrochure()
{
    return $this->hasOne(Brochure::class, 'conference_id')
                ->where('page_type', 12); // Sponsorship brochure
}

// In app/Models/Conference.php

public function SponsorshipThankYouMetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 33); // Sponsorship Thank You page
}

// In app/Models/Conference.php

public function stripeSessions()
{
    return $this->hasMany(StripeSession::class, 'conference_id');
}

// In app/Models/Conference.php

public function subscriptions()
{
    return $this->hasMany(Subscription::class, 'conference_id');
}

public function SubscriberMetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 36); // Subscriber page
}
public function UnSubscriberMetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 35); // UnSubscriber page
}
// In app/Models/Conference.php

public function thankYouBrochures()
{
    return $this->hasMany(Brochure::class, 'conference_id')
                ->where('page_type', 1);
}

// In app/Models/Conference.php

public function venue()
{
    return $this->hasOne(Venue::class, 'conference_id')->where('status', 1);
}

public function venue1()
{
    return $this->hasOne(Venue1::class, 'conference_id')->where('status', 1);
}

public function venueImages()
{
    return $this->hasMany(VenueImage::class, 'conference_id')->where('status', 1)->orderBy('id', 'ASC');
}

public function cityAttractions()
{
    return $this->hasMany(CityAttraction::class, 'conference_id')->where('status', 1);
}
// In app/Models/Conference.php

public function VenueV1metaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 13); // Venue V1 page
}

// In app/Models/Conference.php

public function HomepageMetaData()
{
    return $this->hasOne(MetaData::class, 'conference_id')->where('page_type', 1); // Homepage
}



public function aboutUs()
{
    return $this->hasMany(AboutUs::class, 'conference_id')->where('status', 1);
}

public function quickLinks()
{
    return $this->hasMany(QuickLink::class, 'conference_id')->where('status', 1)->orderBy('order_position', 'ASC');
}

public function homePastGalleries()
{
    return $this->hasMany(HomePastGallery::class, 'conference_id')
        ->where('status', 1);
}



public function importantDates()
{
    return $this->hasMany(ImpDate::class, 'conference_id')->where('status', 1)->orderBy('id', 'ASC');
}

public function ocmSpeakers()
{
    return $this->hasMany(Cspeaker::class, 'conference_id')->where('speaker_type', 1)->where('status', 1)->orderBy('orderpos', 'ASC')->limit(4);
}



public function keynoteSpeakers()
{
    return $this->hasMany(Cspeaker::class, 'conference_id')->where('speaker_type', 2)->where('status', 1)->orderBy('orderpos', 'ASC')->limit(4);
}

public function eminentSpeakers()
{
    return $this->hasMany(Cspeaker::class, 'conference_id')->where('speaker_type', 6)->where('status', 1)->orderBy('orderpos', 'ASC')->limit(4);
}

public function supportJournals()
{
    return $this->hasMany(SupportJournal::class, 'conference_id')->where('status', 1)->orderBy('order_position', 'ASC');
}

public function earlyBirds()
{
    return $this->hasMany(EarlyBird::class, 'conference_id')->where('status', 1)->orderBy('id', 'DESC');
}

public function workshops()
{
    return $this->hasMany(Workshop::class, 'conference_id')->orderBy('id', 'DESC');
}



public function globalTargets()
{
    return $this->hasMany(GlobalTarget::class, 'conference_id')->where('status', 1)->orderBy('id', 'DESC');
}

public function skeletonSchedules()
{
    return $this->hasMany(SkeletonSchedule::class, 'conference_id')->where('status', 1);
}

public function skeletonScheduleContent()
{
    return $this->hasOne(SkeletonScheduleContent::class, 'conference_id')->where('status', 1);
}

public function pastConferences()
{
    return $this->hasMany(PastConference::class, 'conference_id')->where('status', 1);
}

public function welcomeMessages()
{
    return $this->hasMany(WelcomeMessage::class, 'conference_id')->where('status', 1)->orderBy('id', 'ASC');
}




public function testimonials()
{
    return $this->hasMany(Testimonial::class, 'conference_id')->where('status', 1)->orderBy('id', 'DESC');
}

public function fieldWisePrograms()
{
    return $this->hasMany(FieldWise::class, 'conference_id');
}

public function homepageContent()
{
    return $this->hasOne(HomepageContent::class, 'conference_id')->where('status', 1);
}
public function pastConf()
{
    return $this->hasMany(PreviousConferenceGallery::class, 'conference_id', 'id')
                ->where('status', 1)
                ->where('parent_id', 0)
                ->orderBy('id', 'ASC');
}




}