<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanySpeaker extends Model
{
    use HasFactory;

    // ✅ If your table is not 'company_speakers', set it explicitly:
    protected $table = 'c_speakers';

    // ✅ If the primary key is not 'id', specify it:
    protected $primaryKey = 'id';

    // ✅ Allow mass assignment (adjust columns as needed)
    protected $fillable = [
        'speaker_name',
        'speaker_title',
        'alias_name',
        'affliation',
        'speaker_img',
        'country_id',
        'city_id',
        'conference_id',
        'status'
    ];

    // ✅ Relationship to Country
    public function country()
    {
        return $this->belongsTo(CompanyCountry::class, 'country_id');
    }

    // ✅ Relationship to City
    public function city()
    {
        return $this->belongsTo(CompanyCity::class, 'city_id');
    }

    // ✅ Relationship to Conference
    public function conference()
    {
        return $this->belongsTo(CompanyConference::class, 'conference_id');
    }
}
