<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyPresentation extends Model
{
    use HasFactory;

    // ✅ Main (not journal) database
    protected $connection = 'mysql';
    protected $table = 'c_speakers';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id',
        'speaker_name',
        'alias_name',
        'affliation',
        'biography',
        'researchIntrest',
        'speaker_type',
        'country_id',
        'city_id',
        'status',
    ];

    /**
     * Laravel equivalent of getPosterPresentationsByKeyword()
     */
    public static function getPosterPresentationsByKeyword($keyword = null)
    {
        $query = self::on('mysql')
            ->where('status', 1)
            ->where('speaker_type', 4);

        if (!empty($keyword)) {
            $query->where(function ($q) use ($keyword) {
                $q->where('speaker_name', 'like', "%{$keyword}%")
                    ->orWhere('affliation', 'like', "%{$keyword}%")
                    ->orWhere('biography', 'like', "%{$keyword}%")
                    ->orWhere('researchIntrest', 'like', "%{$keyword}%");
            });
        }

        return $query->orderBy('speaker_name', 'ASC')->get();
    }
}
