<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyJournal extends Model
{
    use HasFactory;

    // 👇 use the second DB connection
    protected $connection = 'journal';

    protected $table = 'journals';
    protected $primaryKey = 'id';

    protected $fillable = [
        'journal_name',
        'short_name',
        'status',
        'issn',
        'publisher',
        'description',
    ];

    // === RELATIONSHIPS ===

    // Each journal has many articles
    public function articles()
    {
        return $this->hasMany(CompanyArticle::class, 'journal_id');
    }
}
