<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;

class CompanyConference extends Model
{
    protected $table = 'conferences';
    protected $fillable = [
        'unique_id', 'conference_first_title', 'conference_name', 'short_name', 'short_alias_name',
        'conference_theme', 'conference_location', 'folder_name', 'conference_url',
        'from_date', 'to_date', 'conference_img', 'country_id', 'city_id',
        'continent_id', 'msubject_id', 'publish_status', 'status', 'prev_conf'
    ];

    public function country()
    {
        return $this->belongsTo(CompanyCountry::class, 'country_id');
    }

    public function city()
    {
        return $this->belongsTo(CompanyCity::class, 'city_id');
    }

    public function subject()
    {
        return $this->belongsTo(CompanySubject::class, 'msubject_id');
    }

    public function continent()
    {
        return $this->belongsTo(CompanyContinent::class, 'continent_id');
    }
}
