<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyCollaboration extends Model
{
    use HasFactory;

    // ✅ Same as $this->db2 in CI3
    protected $connection = 'journal';
    protected $table = 'collaborations';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'id',
        'collaboration_name',
        'related_conf_journal',
        'collaboration_desc',
        'status',
    ];

    /**
     * Laravel equivalent of getCollaborationsByKeyword()
     */
    public static function getCollaborationsByKeyword($keyword = null)
    {
        $query = self::on('journal')->where('status', 1);

        if (!empty($keyword)) {
            $query->where(function ($q) use ($keyword) {
                $q->where('collaboration_name', 'like', "%{$keyword}%")
                    ->orWhere('related_conf_journal', 'like', "%{$keyword}%")
                    ->orWhere('collaboration_desc', 'like', "%{$keyword}%");
            });
        }

        return $query->orderBy('collaboration_name', 'ASC')->get();
    }
}
