<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;

class CompanyCity extends Model
{
    protected $table = 'cities';
    protected $fillable = ['city_name', 'status', 'country_id'];

    public function country()
    {
        return $this->belongsTo(CompanyCountry::class, 'country_id');
    }

    public function conferences()
    {
        return $this->hasMany(CompanyConference::class, 'city_id');
    }
}
