<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyArticle extends Model
{
    use HasFactory;

    protected $connection = 'journal'; // 👈 tells Laravel to use DB2
    protected $table = 'j_articles';
    protected $primaryKey = 'id';

    protected $fillable = [
        'article_title',
        'research_artcle',
        'citation',
        'doi',
        'doi_url',
        'abstract_content',
        'journal_id',
        'status'
    ];

    // Relationships
    public function journal()
    {
        return $this->belongsTo(CompanyJournal::class, 'journal_id');
    }

    public function authors()
    {
        return $this->hasMany(CompanyArticleAuthor::class, 'articleid', 'id')
            ->where('status', 1)
            ->with('author');
    }

    // Search scope
    public function scopeSearchByKeyword($query, $keyword)
    {
        return $query->where('status', 1)
            ->where(function ($q) use ($keyword) {
                $q->where('article_title', 'like', "%$keyword%")
                  ->orWhere('research_artcle', 'like', "%$keyword%")
                  ->orWhere('citation', 'like', "%$keyword%")
                  ->orWhere('doi', 'like', "%$keyword%")
                  ->orWhere('abstract_content', 'like', "%$keyword%");
            })
            ->orderBy('article_title', 'ASC');
    }
}
