<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Brochure extends Model
{
    protected $table = 'c_brouchers'; // Note: typo in table name
    public $timestamps = false;

    protected $appends = ['pdf_url','brochure_url'];

    public function getPdfUrlAttribute()
    {
        if ($this->brouchure_name && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->brouchure_name);
        }
        return '';
    }
 public function getBrochureUrlAttribute()
    {
        if ($this->brouchure_name && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->brouchure_name);
        }
        return null;
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}