<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AbstractSubmission extends Model
{
    protected $fillable = [
        'conference_id','designation','abstract_category_id','abstract_title',
        'firstname','lastname','country_id','company','usr_email','user_phone',
        'usr_whatsapp','session_track_id','user_type','user_file','queries','unique_id'
    ];

    protected static function booted()
    {
        static::creating(function ($submission) {
            $submission->unique_id = now()->format('smdiYH');
        });
    }

    public function setUsrEmailAttribute($value)
    {
        $this->attributes['usr_email'] = strtolower($value);
    }

    public function conference()   { return $this->belongsTo(Conference::class); }
    public function category()     { return $this->belongsTo(AbstractCategory::class, 'abstract_category_id'); }
    public function country()      { return $this->belongsTo(Country::class); }
    public function sessionTrack() { return $this->belongsTo(SessionTrack::class, 'session_track_id'); }
}
