<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Conferenceadmin\User;

class ConferenceAdminAuth
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->header('Authorization');

        if (!$token) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        // Remove "Bearer " prefix
        $token = str_replace('Bearer ', '', $token);

        $user = User::where('api_token', $token)
            ->whereIn('usertype', [1, 2, 4])
            ->where('status', 1)
            ->first();

        if (!$user) {
            return response()->json(['message' => 'Invalid or expired token'], 401);
        }

        // Attach user object to request
        $request->merge(['user' => $user]);
        return $next($request);
    }
}
