<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class MetaController extends Controller
{
    public function show($page)
    {
        // Example meta data (you can pull this from DB later)
        $metaList = [
            'venue' => [
                'title' => 'Venue - Climate Change 2025',
                'description' => 'Join us in Berlin for the Climate Change Conference 2025.',
                'image' => 'https://climatechangeconferences.org/images/og-venue.jpg',
                'url' => 'https://climatechangeconferences.org/venue',
            ],
            'about' => [
                'title' => 'About - Climate Change 2025',
                'description' => 'Learn about Climate Change 2025 Conference.',
                'image' => 'https://climatechangeconferences.org/images/og-about.jpg',
                'url' => 'https://climatechangeconferences.org/about',
            ],
        ];

        $meta = $metaList[$page] ?? [
            'title' => 'SciSynopsis Conferences',
            'description' => 'Explore international scientific conferences organized by SciSynopsis Group.',
            'image' => 'https://scisynopsisconferences.com/images/default-og.jpg',
            'url' => 'https://climatechangeconferences.org/',
        ];

        return response()->view('meta-proxy', compact('meta'));
    }
}
