<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class NewsletterController extends Controller
{
    public function subscribe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'current_page' => 'nullable|url'
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => 'Invalid email'], 400);
        }

        // TODO: Save to DB or Mailchimp
        // For now, just log or send confirmation email
        \Log::info('New subscriber', ['email' => $request->email]);

        // Optional: Send welcome email
        // Mail::to($request->email)->send(new \App\Mail\NewsletterWelcome());

        return response()->json(['message' => 'Thank you for subscribing!']);
    }
}