<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Company\CompanyPreviousConferenceVideos;
use App\Models\Company\{
    CompanyMetaData,
    CompanyBanner,
    CompanyHomepageScript,
    CompanyWebCms,
    CompanyChatScript,
    CompanyWhatsApp,
    CompanyPageNavigation,
    CompanyConfiguration
};

class CompanyVideoController extends Controller
{
    public function getVideos(Request $request, $yearId = null)
    {
        $pageType = 7;

        $meta = CompanyMetaData::where('page_type', $pageType)->latest('id')->first();
        $homepage_script = CompanyHomepageScript::where('status', 1)->latest('id')->first();
        $banners = CompanyBanner::where(['status' => 1, 'page_type' => $pageType])->orderByDesc('id')->get();

        $years = CompanyPreviousConferenceVideos::select('year_id')
            ->where('status', 1)
            ->distinct()
            ->orderByDesc('year_id')
            ->get();

        $yearsList = [];
        foreach ($years as $year) {
            $galleryVideos = CompanyPreviousConferenceVideos::where('status', 1)
                ->where('year_id', $year->year_id)
                ->get();

            $yearsList[] = [
                'year_id' => $year->year_id,
                'galleryVideos' => $galleryVideos,
            ];
        }

        return response()->json([
            'meta' => $meta,
            'homepage_script' => $homepage_script?->script_content,
            'banners' => $banners,
            'yearsList' => $yearsList,
        ]);
    }
}
