<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use App\Models\Company\CompanyMetaData;
use App\Models\Company\CompanyHomepageScript;
use App\Models\Company\CompanyPageNavigation;
use Illuminate\Http\JsonResponse;

class CompanyHeaderController extends Controller
{
    public function index()
    {
        $meta = CompanyMetaData::where('page_type', 21) // or dynamic based on route
                                ->latest('id')
                                ->first();

        $homepageScript = CompanyHomepageScript::where('status', 1)
                                               ->latest('id')
                                               ->first();

        $headerNavigation = CompanyPageNavigation::where('status', 1)
                                                 ->where('page_type', 1)
                                                 ->where('parent_id', 0)
                                                 ->orderBy('orderpos', 'ASC')
                                                 ->with('children')
                                                 ->get();

        return response()->json([
            'meta' => $meta,
            'homepage_script' => $homepageScript ? $homepageScript->script_content : null,
            'headerNavigation' => $headerNavigation,
        ]);
    }
}