<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use App\Models\Company\CompanyPageNavigation;
use App\Models\Company\CompanyWebCms;
use App\Models\Company\CompanyWhatsApp;
use App\Models\Company\CompanyChatScript;
use Illuminate\Http\JsonResponse;

class CompanyFooterController extends Controller
{
    public function index()
    {
        $footerQuickLinks = CompanyPageNavigation::where('status', 1)
                                                 ->where('page_type', 2)
                                                 ->where('parent_id', 0)
                                                 ->orderBy('orderpos', 'ASC')
                                                 ->get();

        $footerUsefulLinks = CompanyPageNavigation::where('status', 1)
                                                  ->where('page_type', 3)
                                                  ->where('parent_id', 0)
                                                  ->orderBy('orderpos', 'ASC')
                                                  ->get();

        $address = CompanyWebCms::on('mainsiteDb')->where('status', 1)
                                ->where('page_type', 10)
                                ->orderBy('id', 'ASC')
                                ->first();

        $whatsapp = CompanyWhatsApp::where('status', 1)->latest('id')->first();
        $socialLinks = CompanyWebCms::where('status', 1)
                                    ->where('page_type', 11)
                                    ->latest('id')
                                    ->first();
        $chatScript = CompanyChatScript::where('status', 1)->latest('id')->first();

        return response()->json([
            'footerQuickLinks' => $footerQuickLinks,
            'footerUsefulLinks' => $footerUsefulLinks,
            'address' => $address,
            'whatsapp' => $whatsapp,
            'sociallinks' => $socialLinks,
            'chatScript' => $chatScript ? $chatScript->script_content : null,
        ]);
    }
}