<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class VenueV1ApiController extends Controller
{
    public function show($id)
    {
        $conference = DB::table('conferences')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Venue info
        $venueInfo = DB::table('c_venue')
            ->where(['conference_id' => $id, 'status' => 1])
            ->orderBy('id', 'DESC')
            ->first();

        $venueInfo1 = DB::table('c_venue1')
            ->where(['conference_id' => $id, 'status' => 1])
            ->orderBy('id', 'ASC')
            ->get();

        $venueImages = DB::table('c_venue_images')
            ->where(['conference_id' => $id, 'status' => 1])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($img) use ($uploadsBase, $conference) {
                $img->image_url = $img->cms_img
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($img->cms_img)
                    : null;
                return $img;
            });

        $attractionsInfo = DB::table('c_city_attractions')
            ->where(['conference_id' => $id, 'status' => 1])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($attract) use ($uploadsBase, $conference) {
                $attract->image_url = $attract->attraction_img
                    ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($attract->attraction_img)
                    : null;
                return $attract;
            });

        $faqs = DB::table('venue_page')
            ->where(['conference_id' => $id])
            ->orderBy('id', 'ASC')
            ->get();

        // Acceptance letter URL
        $letterUrl = $venueInfo?->letter_doc
            ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($venueInfo->letter_doc)
            : null;

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 13])
            ->first();

        return response()->json([
            'success' => true,
            'venueData' => compact('venueInfo', 'venueInfo1', 'venueImages', 'attractionsInfo', 'faqs', 'letterUrl'),
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Venue – Conference',
                'description' => $metaRecord->meta_description ?? 'Conference venue, address, map, and city attractions.',
                'keywords' => 'venue, address, map, attractions, conference'
            ]
        ]);
    }
}