<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SubscriptionApiController extends Controller
{
    // Show Subscribe/Unsubscribe Page
    public function show($id)
    {
        $conference = DB::table('conferences')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }


        return response()->json([
            'success' => true,
            'meta' => [
                'title' => 'Subscribe – Conference',
                'description' => 'Stay updated with our latest news and announcements.'
            ],
            
            'conferenceInfo' => [
                'id' => $conference->id,
                'conference_url' => $conference->conference_url,
                'unique_id' => $conference->unique_id
            ]
        ]);
    }

    // Handle Subscribe
    public function subscribe(Request $request, $id)
    {
        

        $current_page = $request->input('current_page', "https://{$id}");
        $curDate = now();

        // Check if already subscribed
        $existing = DB::table('c_users_subs')
            ->where('usr_email', $request->email)
            ->where('conference_id', $id)
            ->first();

        if ($existing) {
            // Reactivate
            DB::table('c_users_subs')
                ->where('id', $existing->id)
                ->update(['status_s' => 1, 'name' => $request->name]);

            return response()->json([
                'success' => true,
                'message' => 'Thank you for subscribing again!'
            ]);
        } else {
            // Insert new
            $insertId = DB::table('c_users_subs')->insertGetId([
                'conference_id' => $id,
                'usr_email' => $request->email,
                'name' => $request->name,
                'page_url' => $current_page,
                'created_date' => $curDate,
                'status_s' => 1
            ]);

            return $insertId
                ? response()->json(['success' => true, 'message' => 'Thank you for subscribing us. We will get back to you shortly.'])
                : response()->json(['success' => false, 'error' => 'Failed to save.']);
        }
    }

    // Handle Unsubscribe
    public function unsubscribe(Request $request, $id)
    {
        $updated = DB::table('c_users_subs')
            ->where('usr_email', $request->email)
            ->where('conference_id', $id)
            ->update([
                'status_s' => 0,
                'unsub_date' => now(),
                'reason_des' => $request->reason,
                'name' => $request->name
            ]);

        return response()->json(['success' => true, 'message' => 'We are sorry to see you go. Thank you.']);
    }
}