<?php
// app/Http/Controllers/Api/SpeakersPageApiController.php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SpeakersPageApiController extends Controller
{
    public function show(Request $request, $id)
    {
        $speaker_type = $request->query('speaker_type','6');

        if ($speaker_type === '2') {
            $page_type = 7;
            $clmName = 'Keynote Speakers';
            $clmName1 = 'Keynote';
            $clmName2 = 'Speakers';
            $cntlrname = 'keynote-speakers';
            $defaultMeta = ['title'=>'Keynote Speakers – Conference','description'=>'Our distinguished keynote speakers.','keywords'=>'keynote speakers, conference, experts'];
        } else {
            $page_type = 24;
            $clmName = 'Eminent Speakers';
            $clmName1 = 'Eminent';
            $clmName2 = 'Speakers';
            $cntlrname = 'eminent-speakers';
            $defaultMeta = ['title'=>'Eminent Speakers – Conference','description'=>'Our eminent speakers and industry leaders.','keywords'=>'eminent speakers, conference, leaders'];
        }

        $conference = DB::table('conferences')->where('id',$id)->first();

        $banners = DB::table('c_banners')
            ->where(['conference_id'=>$id,'page_type'=>$page_type,'status'=>1])
            ->orderByDesc('id')->get();

        $metaRow = DB::table('c_meta_data')
            ->where(['conference_id'=>$id,'page_type'=>$page_type])
            ->orderByDesc('id')->first();

        $speakers = DB::table('c_speakers as s')
            ->leftJoin('countries as c', function($j){ $j->on('c.id','=','s.country_id')->where('c.status',1); })
            ->select(['s.id','s.conference_id','s.alias_name','s.speaker_img','s.speaker_name','s.speaker_title','s.affliation','s.speaker_type','c.country_name'])
            ->where(['s.conference_id'=>$id,'s.speaker_type'=>$speaker_type])
            ->orderBy('s.orderpos','ASC')->get();

        $cmsInfo = $speakers->map(function($s){
            return [
                'id'=>$s->id,
                'alias_name'=>$s->alias_name,
                'speaker_img'=>$s->speaker_img,
                'speaker_name'=>$s->speaker_name,
                'speaker_title'=>$s->speaker_title,
                'affliation'=>$s->affliation,
                'speaker_type'=>$s->speaker_type,
                'countryInfo'=>$s->country_name ? [ ['country_name'=>$s->country_name] ] : []
            ];
        })->values();

        $prevRows = DB::table('c_previous_speakers')
            ->where(['conference_id'=>$id,'speaker_type'=>$speaker_type])
            ->orderBy('orderpos','ASC')->get();

        $previousSpeakers = [];
        foreach ($prevRows as $row) {
            $prevConf = DB::table('conferences')->where('id',$row->previous_conference_id)->first();
            if (!$prevConf) continue;

            $prevSpk = DB::table('c_speakers as s')
                ->leftJoin('countries as c', function($j){ $j->on('c.id','=','s.country_id')->where('c.status',1); })
                ->select(['s.id','s.alias_name','s.speaker_img','s.speaker_name','s.affliation','s.speaker_title','s.conference_id','c.country_name'])
                ->where(['s.status'=>1,'s.conference_id'=>$row->previous_conference_id,'s.speaker_type'=>$speaker_type])
                ->orderBy('s.orderpos','ASC')->get();

            $speakersInfo = $prevSpk->map(function($ps){
                return [
                    'id'=>$ps->id,
                    'alias_name'=>$ps->alias_name,
                    'speaker_img'=>$ps->speaker_img,
                    'speaker_name'=>$ps->speaker_name,
                    'affliation'=>$ps->affliation,
                    'speaker_title'=>$ps->speaker_title,
                    'conference_id'=>$ps->conference_id,
                    'countryInfo'=>$ps->country_name ? [ ['country_name'=>$ps->country_name] ] : [],
                    'universityInfo'=>[],
                    'hospitalInfo'=>[]
                ];
            })->values();

            $previousSpeakers[] = [
                'id'=>$row->id,
                'conference_id'=>$row->conference_id,
                'previous_conference_id'=>$row->previous_conference_id,
                'orderpos'=>$row->orderpos,
                'status'=>$row->status,
                'prevConfInfo'=>[[
                    'id'=>$prevConf->id,
                    'conference_name'=>$prevConf->conference_name,
                    'unique_id'=>$prevConf->unique_id,
                    'folder_name'=>$prevConf->folder_name
                ]],
                'speakersInfo'=>$speakersInfo
            ];
        }

        return response()->json([
            'success'=>true,
            'cntlrname'=>$cntlrname,
            'clmName'=>$clmName,
            'clmName1'=>$clmName1,
            'clmName2'=>$clmName2,
            'speaker_type'=>$speaker_type,
            'cmsInfo'=>$cmsInfo,
            'previousSpeakers'=>$previousSpeakers,
            'banners'=>$banners,
            'meta'=>[
                'title'=>$metaRow->meta_title ?? $defaultMeta['title'],
                'description'=>$metaRow->meta_description ?? $defaultMeta['description'],
                'keywords'=>$metaRow->meta_keywords ?? $defaultMeta['keywords']
            ],
            'conferenceInfo'=>$conference ? [ $conference ] : []
        ]);
    }
}
