<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Models\Order;

class PaymentController extends Controller
{
    public function success(Request $request)
    {
        $request->validate([
            'order_id' => 'required',
            'transaction_id' => 'required',
            'method' => 'required'
        ]);

        // Update payment status
        DB::table('payments')->updateOrInsert(
            ['order_id' => $request->order_id],
            [
                'transaction_id' => $request->transaction_id,
                'method' => $request->method,
                'status' => 'success',
                'paid_at' => now()
            ]
        );

        // Get user & conference
        $user = DB::table('c_reg_users')->where('id', $request->user_id)->first();
        $conference = DB::table('conferences')->where('id', $user->conference_id)->first();

        if (!$user || !$conference) {
            return response()->json(['error' => 'User or conference not found'], 404);
        }

        // Send email (like CI3 success())
        $subject = "Thank You for Registration for " . $conference->short_name;

        // Use Laravel Mail or custom send function
        \Mail::raw("Dear {$user->firstname},\n\nThank you for registering for {$conference->conference_name}.\n\nTransaction ID: {$request->transaction_id}\n\nBest regards,\n{$conference->short_name} Team", function ($message) use ($user, $subject) {
            $message->to($user->usr_email)
                    ->subject($subject);
        });

        return response()->json(['success' => true]);
    }
    
    
    public function paypalSuccess($conferenceId, Request $request)
    {
        // Success redirect (PayerID, token etc. come from PayPal)
        $orderId = $request->input('item_number_1');
        $order = Order::where('order_id', $orderId)->first();

        if ($order) {
            $order->status = 'paid';
            $order->transaction_id = $request->input('txn_id') ?? $request->input('PayerID');
            $order->save();
        }

        return redirect('/payment-success?order_id='.$orderId);
    }

    public function paypalCancel()
    {
        return view('payments.cancelled');
    }

    public function paypalIpn(Request $request)
    {
        Log::info('PayPal IPN', $request->all());
        // TODO: validate IPN message from PayPal
        return response('OK', 200);
    }
}