<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ConferenceGalleryApiController extends Controller
{
    public function index($id)
    {
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/gallery";

        // Fetch all top-level albums (parent_id = 0)
        $albums = DB::table('previous_conference_gallery')
            ->where([
                'conference_id' => $id,
                'parent_id' => 0,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($album) use ($uploadsBase, $conference) {
                $album->image_url = $album->gallery_img
                    ? "{$uploadsBase}/{$album->gallery_img}"
                    : null;
                return $album;
            });

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 26])
            ->first();

        return response()->json([
            'success' => true,
            'galleryData' => [
                'albums' => $albums
            ],
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Conference Gallery – Conference',
                'description' => $metaRecord->meta_description ?? 'View photos from our past conferences.',
                'keywords' => $metaRecord->meta_keywords ?? 'gallery, photos, conference, event'
            ]
        ]);
    }

    public function show($id, $alias_name)
    {
        $conference = DB::table('conferences')->select('unique_id')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/gallery";

        // Get album by alias_title
        $album = DB::table('previous_conference_gallery')
            ->where([
                'conference_id' => $id,
                'alias_title' => $alias_name,
                'parent_id' => 0,
                'status' => 1
            ])
            ->first();

        if (!$album) {
            return response()->json(['success' => false, 'message' => 'Album not found'], 404);
        }

        // Get images in album (parent_id = album id)
        $images = DB::table('previous_conference_gallery')
            ->where([
                'conference_id' => $id,
                'parent_id' => $album->id,
                'status' => 1
            ])
            ->orderBy('id', 'ASC')
            ->get()
            ->map(function ($img) use ($uploadsBase) {
                $img->image_url = $img->gallery_img
                    ? "{$uploadsBase}/{$img->gallery_img}"
                    : null;
                return $img;
            });

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 26])
            ->first();

        return response()->json([
            'success' => true,
            'galleryDetailsData' => [
                'album' => $album,
                'images' => $images
            ],
            'meta' => [
                'title' => $album->gallery_title . ' – Conference Gallery – Conference',
                'description' => 'Photos from ' . $album->gallery_title,
                'keywords' => 'gallery, photos, ' . $album->gallery_title
            ]
        ]);
    }
}