<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class CommonApiController extends Controller
{
    public function show($id)
    {
        $conferenceInfo = DB::table('conferences')->find($id);
		$meta = DB::table('c_meta_data')->where('conference_id', $conferenceId)->where('page_type', $page_type)->first();
        if (!$conferenceInfo) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'success' => true,
            'conferenceInfo' => $conferenceInfo,
            'headercontent' => DB::table('c_header_content')->where('conference_id', $id)->first(),
            'headerNavigation' => $this->getHeaderNavigation($id),
            'footerQuickLinks' => DB::table('c_page_navigations')
                ->where(['conference_id' => $id, 'page_type' => 2, 'status' => 1])
                ->orderBy('orderpos')->get(),
            'footerUsefulLinks' => DB::table('c_page_navigations')
                ->where(['conference_id' => $id, 'page_type' => 3, 'status' => 1])
                ->orderBy('orderpos')->get(),
            'socialLinks' => DB::table('c_social')->where(['conference_id' => $id, 'status' => 1])->get(),
            'mainaddress' => DB::table('web_cms')->where(['page_type' => 10, 'status' => 1])->first(),
            'contactInfo' => DB::table('c_address')->where(['conference_id' => $id, 'status' => 1])->first(),
            'whatsappNumber' => DB::table('c_address')->where('conference_id', $id)->value('whatsapp_number'),
            'gkey' => $conferenceInfo->gkey,
            'meta' => [
                'title' => $meta->meta_title ?? $meta->title ?? '',
                'description' => $meta->meta_description ?? '',
                'keywords' => $meta->meta_keywords ?? ''
            ],
            'favicon' => $conferenceInfo->fav_icon ?? ''
        ]);
    }

    private function getHeaderNavigation($conferenceId)
    {
        return DB::table('c_page_navigations')
            ->where(['conference_id' => $conferenceId, 'page_type' => 1, 'status' => 1, 'parent_id' => 0])
            ->orderBy('orderpos')
            ->get()
            ->map(function ($item) use ($conferenceId) {
                $item->headerSubNav = DB::table('c_page_navigations')
                    ->where(['conference_id' => $conferenceId, 'parent_id' => $item->id, 'status' => 1])
                    ->orderBy('orderpos')->get();
                return $item;
            });
    }
}
