<?php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class CallForPapersApiController extends Controller
{
    public function index($id)
    {
        $banners = DB::table('c_banners')
            ->where(['status' => 1, 'page_type' => 4, 'conference_id' => $id])
            ->get();

        $tracks = DB::table('c_session_tracks')
            ->where(['status' => 1, 'conference_id' => $id, 'parent_id' => 0])
            ->orderBy('orderpos', 'ASC')
            ->get();

        $sessionTracks = [];
        foreach ($tracks as $track) {
            $subtracks = DB::table('c_session_tracks')
                ->where(['status' => 1, 'conference_id' => $id, 'parent_id' => $track->id])
                ->orderBy('orderpos', 'ASC')
                ->get();

            $sessionTracks[] = [
                'id' => $track->id,
                'track_title' => $track->track_title,
                'track_icon' => $track->track_icon,
                'cms_img' => $track->cms_img,
                'alias_title' => $track->alias_title,
                'track_desc' => $track->track_desc,
                'subtracks' => $subtracks ? $subtracks->toArray() : []
            ];
        }

        $meta = DB::table('c_meta_data')
            ->where(['page_type' => 4, 'conference_id' => $id])
            ->first();

        return response()->json([
            'success' => true,
            'callForPapersData' => [
                'banners' => $banners,
                'sessionTracks' => $sessionTracks
            ],
            'meta' => $meta ? (array) $meta : []
        ]);
    }

    public function show($id, $alias_name)
    {
        $track = DB::table('c_session_tracks')
            ->where([
                'conference_id' => $id,
                'alias_title' => $alias_name,
                'status' => 1
            ])
            ->first();

        if (!$track) {
            return response()->json(['error' => 'Track not found'], 404);
        }

        $subtracks = DB::table('c_session_tracks')
            ->where(['status' => 1, 'conference_id' => $id, 'parent_id' => $track->id])
            ->orderBy('orderpos', 'ASC')
            ->get();

        $meta = DB::table('c_meta_data')
            ->where(['page_type' => 4, 'conference_id' => $id])
            ->first();

        return response()->json([
            'success' => true,
            'sessionDetailsData' => [
                'id' => $track->id,
                'track_title' => $track->track_title,
                'track_icon' => $track->track_icon,
                'cms_img' => $track->cms_img,
                'alias_title' => $track->alias_title,
                'track_desc' => $track->track_desc,
                'subtracks' => $subtracks ? $subtracks->toArray() : []
            ],
            'meta' => $meta ? (array) $meta : []
        ]);
    }
}