<?php
// app/Http/Controllers/Api/AllSpeakersApiController.php
namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class AllSpeakersApiController extends Controller
{
    public function show($id)
    {
        $meta = DB::table('c_meta_data')
            ->where(['conference_id'=>$id,'page_type'=>24])
            ->orderByDesc('id')->first();

        $conference = DB::table('conferences')->where('id',$id)->first();

        $banners = DB::table('c_banners')
            ->where(['status'=>1,'conference_id'=>$id,'page_type'=>24])
            ->orderByDesc('id')->get();

        $categories = DB::table('categories_new')->orderBy('sort_order','ASC')->get();

        $groupedSpeakers = [];
        $index = [];
        foreach ($categories as $i=>$cat) {
            $groupedSpeakers[] = ['category_id'=>$cat->id,'category_name'=>$cat->category_name,'speakers'=>[]];
            $index[$cat->id] = $i;
        }

        $speakers = DB::table('c_speakers1')->where('conference_id',$id)->orderBy('orderpos','ASC')->get();

        foreach ($speakers as $s) {
            if (!isset($index[$s->speaker_type])) continue;
            $country = DB::table('countries')->where(['id'=>$s->country_id,'status'=>1])->first();
            $groupedSpeakers[$index[$s->speaker_type]]['speakers'][] = [
                'id'=>$s->id,
                'speaker_img'=>$s->speaker_img,
                'alias_name'=>$s->alias_name,
                'speaker_name'=>$s->speaker_name,
                'speaker_title'=>$s->speaker_title,
                'affliation'=>$s->affliation,
                'speaker_type'=>$s->speaker_type,
                'countryInfo'=>$country ? [ ['country_name'=>$country->country_name] ] : []
            ];
        }

        return response()->json([
            'success'=>true,
            'cntlrname'=>'all-speakers',
            'allspeakersData'=>[
                'groupedSpeakers'=>$groupedSpeakers,
                'banners'=>$banners
            ],
            'meta'=>[
                'title'=>$meta->meta_title ?? 'All Speakers – Conference',
                'description'=>$meta->meta_description ?? 'All speakers grouped by category.',
                'keywords'=>$meta->meta_keywords ?? 'all speakers, conference'
            ],
            'conferenceInfo'=>$conference
        ]);
    }
}
