<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class ThankYouApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with(['thankYouBrochures'])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'success' => true,
            'brchure' => $conference->thankYouBrochures,
            'uploads' => "https://scisynopsisconferences.com/uploads/conferences/{$conference->unique_id}",
            'conferenceId' => $id
        ]);
    }
}