<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Stripe\Webhook;
use Stripe\Exception\SignatureVerificationException;
use Illuminate\Support\Facades\Log;

class StripeWebhookController extends Controller
{
    public function latesthandleWebhook(Request $request)
    {
        $payload = $request->getContent();
        $sigHeader = $request->header('Stripe-Signature');
        $secret = env('STRIPE_WEBHOOK_SECRET'); // copy from Stripe dashboard (test mode first)

        try {
            $event = Webhook::constructEvent($payload, $sigHeader, $secret);
        } catch (SignatureVerificationException $e) {
            Log::error('Latest Stripe Webhook signature mismatch');
            return response('Invalid signature', 400);
        }

       if ($event->type === 'checkout.session.completed') {
    $session = $event->data->object;

    $orderId = $session->metadata->order_id ?? null;
    if ($orderId) {
        // ✅ update order in DB
        $order = \App\Models\Order::find($orderId);
        if ($order) {
            $order->status = 'paid';
            $order->payment_intent = $session->payment_intent;
            $order->save();
        }
    }
}


        return response('ok', 200);
    }
}
