<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Checkout\Session;

class StripePaymentController extends Controller
{
    public function latestcreateCheckout(Request $request)
    {
        $request->validate([
            'order_id' => 'required',
            'amount' => 'required|integer|min:50', // in cents
            'currency' => 'required|in:usd,eur,gbp',
            'user.name' => 'required',
            'user.email' => 'required|email',
        ]);

        Stripe::setApiKey(env('STRIPE_SECRET'));

        try {
            $session = Session::create([
                'payment_method_types' => ['card'],
                'line_items' => [[
                    'price_data' => [
                        'currency' => $request->currency,
                        'unit_amount' => $request->amount, // already cents
                        'product_data' => [
                            'name' => 'Conference Registration',
                        ],
                    ],
                    'quantity' => 1,
                ]],
                'mode' => 'payment',
                'success_url' => env('APP_URL') . '/payment-success?session_id={CHECKOUT_SESSION_ID}',
                'cancel_url' => env('APP_URL') . '/payment-cancelled',
                'customer_email' => $request->user['email'],
                'metadata' => [
                    'order_id' => $request->order_id,
                    'user_name' => $request->user['name'],
                    'user_email' => $request->user['email'],
                ],
            ]);

            return response()->json(['url' => $session->url]);
        } catch (\Exception $e) {
            \Log::error('Latest Stripe session creation failed: ' . $e->getMessage());
            return response()->json(['error' => 'Payment setup failed'], 500);
        }
    }
}
