<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;

class RegistrationControllerV7 extends Controller
{
    public function show($conferenceId)
    {
        // 1️⃣ Validate conference exists
        $conference = DB::table('conferences')->where('id', $conferenceId)->first();
        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        // 2️⃣ Handle currency
        $currency = (int) request('currency', 3);
        $currency = in_array($currency, [1, 2, 3]) ? $currency : 3;

        // 3️⃣ Fetch all required data
        $meta = DB::table('c_meta_data')
            ->where('page_type', 11)
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->first();

        $homepage_script = DB::table('c_homepage_script')
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->first();

        $toppanel = DB::table('c_headerpanel')
            ->where('conference_id', $conferenceId)
            ->where('page_type', 1)
            ->where('status', 1)
            ->orderBy('id', 'asc')
            ->get();

        $sidepanel = DB::table('c_headerpanel')
            ->where('conference_id', $conferenceId)
            ->where('page_type', 2)
            ->where('status', 1)
            ->orderBy('id', 'asc')
            ->get();

        $settings = DB::table('c_settings')
            ->where('conference_id', $conferenceId)
            ->first();

        $banners = DB::table('c_banners')
            ->where('status', 1)
            ->where('page_type', 11)
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->get();

        $designations = DB::table('designations')
            ->where('status', 1)
            ->orderBy('id', 'asc')
            ->get();

        $countries = DB::connection('journal')
            ->table('countries')
            ->where('status', 1)
            ->orderBy('country_name', 'asc')
            ->get();

        $categories = DB::table('categories')
            ->where('status', 1)
            ->orderBy('id', 'asc')
            ->get();

        // ACC & ESPN
        $acpcat = DB::table('acc_espn')
            ->where('conference_id', $conferenceId)
            ->where('ctype', 1)
            ->where('currency_id', $currency)
            ->orderBy('id', 'asc')
            ->get();

        $espncat = DB::table('acc_espn')
            ->where('conference_id', $conferenceId)
            ->where('ctype', 2)
            ->where('currency_id', $currency)
            ->orderBy('id', 'asc')
            ->get();

        $dates = DB::table('c_registrations_dates')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->first();

        // Registration Categories (page_type = 1)
     $regCategories = DB::table('c_registration_categories as cat')
    ->join('c_registrations_amount1 as amt', 'cat.id', '=', 'amt.category_id')
    ->where('cat.status', 1)
    ->where('cat.page_type', 1)
    ->where('amt.conference_id', $conferenceId)
    ->where('amt.currency_id', $currency)
    ->select('cat.id', 'cat.category_name', 'cat.page_type')
    ->distinct()
    ->orderBy('cat.id', 'asc')
    ->get();

$regCatArray = [];
foreach ($regCategories as $cat) {
    $amounts = DB::table('c_registrations_amount1')
        ->where('status', 1)
        ->where('currency_id', $currency)
        ->where('conference_id', $conferenceId)
        ->where('category_id', $cat->id)
        ->orderBy('orderpos', 'asc')
        ->get();

    $regCatArray[] = [
        'id' => $cat->id,
        'category_name' => $cat->category_name,
        'page_type' => $cat->page_type,
        'registrationAmount' => $amounts,
    ];
}

// In your Laravel controller
$addOnArray = [];
$accommodations = DB::table('c_accommodation_v1 as acc')
    ->join('c_registration_categories as cat', 'acc.category_id', '=', 'cat.id')
    ->where('cat.status', 1)
    ->where('cat.page_type', 2)
    ->where('acc.conference_id', $conferenceId)
    ->where('acc.currency_id', $currency)
    ->select(
        'acc.id',
        'acc.accommodation_name',
        'acc.accommodation_amount',
        'cat.id as category_id',
        'cat.category_name'
    )
    ->orderBy('cat.id')
    ->get();

foreach ($accommodations as $item) {
    $addOnArray[] = [
        'id' => $item->id,
        'accommodation_name' => $item->accommodation_name,
        'accommodation_amount' => $item->accommodation_amount,
        'category_id' => $item->category_id,
        'category_name' => $item->category_name,
    ];
}



        $registrationContent = DB::table('c_registration_content')
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'asc')
            ->get();

        $registrationInfo = DB::table('c_registration_info')
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'asc')
            ->get();

        $onsiteStatus = DB::table('c_onsite_reg_status')
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->first();

        // Footer & Theme
        $footerSection = DB::table('c_footer_section')
            ->where('conference_id', $conferenceId)
            ->where('page_type', 11)
            ->orderBy('id', 'asc')
            ->first();
        $footerShow = $footerSection ? $footerSection->status : 1;

        $headingTheme = DB::table('c_heading_theme')
            ->where('conference_id', $conferenceId)
            ->where('page_type', 11)
            ->orderBy('id', 'asc')
            ->first();
        $themeShow = $headingTheme ? $headingTheme->theme_type : 2;

        // Subjects & Continents
        $conferenceSubjects = DB::table('subjects')
            ->where('status', 1)
            ->orderBy('subject_title', 'asc')
            ->get();

        $jounralSubjects = DB::connection('journal')
            ->table('subjects')
            ->where('status', 1)
            ->orderBy('subject_title', 'asc')
            ->get();

        $continents = DB::connection('journal')
            ->table('continents')
            ->where('status', 1)
            ->orderBy('continent_name', 'asc')
            ->get();

        $continentsArray = [];
        foreach ($continents as $continent) {
            $countryInfo = DB::connection('journal')
                ->table('countries')
                ->where('status', 1)
                ->where('continent_id', $continent->id)
                ->orderBy('country_name', 'asc')
                ->get();
            $continentsArray[] = [
                'id' => $continent->id,
                'continent_name' => $continent->continent_name,
                'alias_name' => $continent->alias_name,
                'countryInfo' => $countryInfo,
            ];
        }

        // Addresses & Contact
        $mainaddress = DB::table('web_cms')
            ->where('status', 1)
            ->where('page_type', 10)
            ->orderBy('id', 'desc')
            ->first();

        $address = DB::table('c_address')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->first();

        $whatsapp = DB::table('whatsapp')
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->first();

        $sociallinks = DB::table('c_social')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->first();

        $chatScript = DB::table('c_tawk_scpt')
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'desc')
            ->first();

        $journalsUrl = DB::connection('journal')
            ->table('configurations')
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->first();

        $conferenceUrl = DB::table('configurations')
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->first();

        $termsInfo = DB::table('privacy_terms')
            ->where('status', 1)
            ->where('page_type', 2)
            ->orderBy('id', 'asc')
            ->first();

        $socialUrls = DB::table('c_social_timelines')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->orderBy('id', 'asc')
            ->get();

        // Navigation Menus
        $headerNavigation = DB::table('c_page_navigations')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->where('page_type', 1)
            ->where('parent_id', 0)
            ->orderBy('orderpos', 'asc')
            ->get();

        $navArray = [];
        foreach ($headerNavigation as $nav) {
            $subNav = DB::table('c_page_navigations')
                ->where('status', 1)
                ->where('conference_id', $conferenceId)
                ->where('page_type', 1)
                ->where('parent_id', $nav->id)
                ->orderBy('orderpos', 'asc')
                ->get();

            $navArray[] = [
                'id' => $nav->id,
                'parent_id' => $nav->parent_id,
                'conference_id' => $nav->conference_id,
                'page_name' => $nav->page_name,
                'page_url_type' => $nav->page_url_type,
                'page_url_name' => $nav->page_url_name,
                'is_url' => $nav->is_url,
                'targetchk' => $nav->targetchk,
                'headerSubNav' => $subNav,
            ];
        }

        $footerQuickLinks = DB::table('c_page_navigations')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->where('page_type', 2)
            ->where('parent_id', 0)
            ->orderBy('orderpos', 'asc')
            ->get();

        $footerUsefulLinks = DB::table('c_page_navigations')
            ->where('status', 1)
            ->where('conference_id', $conferenceId)
            ->where('page_type', 3)
            ->where('parent_id', 0)
            ->orderBy('orderpos', 'asc')
            ->get();

        // Math Captcha
        $num1 = rand(1, 20);
        $num2 = rand(1, 20);
        session(['math_captcha_answer_v7' => $num1 + $num2]);

        // Final JSON
        return response()->json([
            "headerNavigation" => $navArray,
            "footerQuickLinks" => $footerQuickLinks,
            "footerUsefulLinks" => $footerUsefulLinks,
            "socialUrls" => $socialUrls,
            "meta" => $meta,
            "homepage_script" => $homepage_script,
            "toppanel" => $toppanel,
            "sidepanel" => $sidepanel,
            "conferenceInfo" => $conference,
            "banners" => $banners,
            "conferenceId" => $conferenceId,
            "homebanners" => 1,
            "designations" => $designations,
            "countries" => $countries,
            "categories" => $categories,
            "acpcat" => $acpcat,
            "espncat" => $espncat,
            "currency" => $currency,
            "dates" => $dates,
            "regCategories" => $regCatArray,
            "addOnCategories" => $addOnArray,
            "registrationContent" => $registrationContent,
            "registrationInfo" => $registrationInfo,
            "onsiteStatus" => $onsiteStatus,
            "termsInfo" => $termsInfo,
            "newcaptcha" => $this->generateRandomPassword(6),
            "footerShow" => $footerShow,
            "themeShow" => $themeShow,
            "conferenceSubjects" => $conferenceSubjects,
            "jounralSubjects" => $jounralSubjects,
            "continentsInfo" => $continentsArray,
            "mainaddress" => $mainaddress,
            "address" => $address,
            "whatsapp" => $whatsapp,
            "sociallinks" => $sociallinks,
            "chatScript" => $chatScript,
            "journalsUrl" => $journalsUrl,
            "conferenceUrl" => $conferenceUrl,
            "settings" => $settings,
 'addOnArray' => $addOnArray,
            // Optional: Add math captcha for frontend validation
            "mathCaptcha" => [
                "question" => "$num1 + $num2 = ?",
            ],
        ]);
    }

    protected function generateRandomPassword($length = 6)
    {
        return substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, $length);
    }

    // Keep your existing refreshCaptcha and store methods
}