<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\ProgramSpeaker;
use Illuminate\Http\JsonResponse;

class ProgramDetailsApiController extends Controller
{
    public function show($id, $alias_name): JsonResponse
    {
        $conference = Conference::with(['ProgramDetailsmetaData'])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $speaker = ProgramSpeaker::with(['country', 'programContent'])
            ->where([
                'conference_id' => $id,
                'alias_name' => $alias_name,
                'status' => 1
            ])
            ->first();

        if (!$speaker) {
            return response()->json([
                'success' => false,
                'message' => 'Speaker not found'
            ], 404);
        }

        $speakerInfo = [
            'id' => $speaker->id,
            'sTitle' => $speaker->sTitle,
            'subTitle' => $speaker->subTitle,
            'alias_name' => $speaker->alias_name,
            'speaker_name' => $speaker->speaker_name,
            'affiliation' => $speaker->affiliation,
            'country_name' => $speaker->country?->country_name ?? '',
            'programContent' => $speaker->programContent->toArray(),
            'photo_url' => $speaker->photo_url, // auto-appended via accessor
        ];

        $meta = $conference->ProgramDetailsmetaData;

        return response()->json([
            'success' => true,
            'programDetailsData' => $speakerInfo,
            'meta' => [
                'title' => $speaker->speaker_name . ' – Scientific Program – Conference',
                'description' => 'View details of ' . $speaker->speaker_name . ' in the scientific program.',
                'keywords' => 'speaker, scientific program, abstract, ' . $speaker->speaker_name
            ]
        ]);
    }
}