<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class MediaPartnersApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with(['mediaPartners'])->find($id);

        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        return response()->json([
            'success' => true,
            'mediaPartners' => $conference->mediaPartners,
            'meta' => [
                'title' => 'Media Partners – ' . ($conference->suname ?? 'Conference'),
                'description' => 'Our esteemed media and collaboration partners.',
                'keywords' => 'media partners, sponsors, collaborations, conference'
            ]
        ]);
    }
}