<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\GalleryItem;
use Illuminate\Http\JsonResponse;

class ConferenceGalleryApiController extends Controller
{
    public function index($id): JsonResponse
    {
        $conference = Conference::with(['ConferenceGallerymetaData'])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        // Fetch all top-level albums (parent_id = 0)
        $albums = GalleryItem::where([
            'conference_id' => $id,
            'parent_id' => 0,
            'status' => 1
        ])
        ->orderBy('id', 'ASC')
        ->get();

        $meta = $conference->ConferenceGallerymetaData;

        return response()->json([
            'success' => true,
            'galleryData' => [
                'albums' => $albums
            ],
            'meta' => [
                'title' => $meta?->meta_title ?? 'Conference Gallery – Conference',
                'description' => $meta?->meta_description ?? 'View photos from our past conferences.',
                'keywords' => $meta?->meta_keywords ?? 'gallery, photos, conference, event'
            ]
        ]);
    }

    public function show($id, $alias_name): JsonResponse
    {
        $conference = Conference::with(['ConferenceGallerymetaData'])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        // Get album by alias_title
        $album = GalleryItem::where([
            'conference_id' => $id,
            'alias_title' => $alias_name,
            'parent_id' => 0,
            'status' => 1
        ])
        ->first();

        if (!$album) {
            return response()->json([
                'success' => false,
                'message' => 'Album not found'
            ], 404);
        }

        // Get images in album (parent_id = album id)
        $images = GalleryItem::where([
            'conference_id' => $id,
            'parent_id' => $album->id,
            'status' => 1
        ])
        ->orderBy('id', 'ASC')
        ->get();

        return response()->json([
            'success' => true,
            'galleryDetailsData' => [
                'album' => $album,
                'images' => $images
            ],
            'meta' => [
                'title' => $album->gallery_title . ' – Conference Gallery – Conference',
                'description' => 'Photos from ' . $album->gallery_title,
                'keywords' => 'gallery, photos, ' . $album->gallery_title
            ]
        ]);
    }
}