<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use App\Models\SessionTrack;
use Illuminate\Http\JsonResponse;

class CallForPapersApiController extends Controller
{
    public function index($id): JsonResponse
    {
   $conference = Conference::with([
        'banners' => function ($q) { $q->where('page_type', 4) ->where('status', 1); },
        'sessionTracks' => function ($q) { $q->where('parent_id', 0)->where('status', 1)->orderBy('orderpos'); },
        'CallForPapersmetaData'
    ])->find($id);


        if (!$conference) {
            return response()->json(['error' => 'Conference not found'], 404);
        }

        // Load subtracks for each top-level track
        $sessionTracks = $conference->sessionTracks->map(function ($track) {
            if (!$track->relationLoaded('subtracks')) {
                $track->load('subtracks');
            }

            return [
                'id' => $track->id,
                'track_title' => $track->track_title,
                'track_icon' => $track->track_icon,
                'cms_img' => $track->cms_img,
                'alias_title' => $track->alias_title,
                'track_desc' => $track->track_desc,
                'subtracks' => $track->subtracks->toArray(),
            ];
        });

        $meta = $conference->CallForPapersmetaData;

        return response()->json([
            'success' => true,
            'callForPapersData' => [
                'banners' => $conference->banners,
                'sessionTracks' => $sessionTracks
            ],
            'meta' => $meta ? (array) $meta : []
        ]);
    }

    public function show($id, $alias_name): JsonResponse
    {
        $track = SessionTrack::with(['subtracks'])
            ->where('conference_id', $id)
            ->where('alias_title', $alias_name)
            ->where('status', 1)
            ->first();

        if (!$track) {
            return response()->json(['error' => 'Track not found'], 404);
        }

        $meta = SessionTrack::find($id)?->conference->CallForPapersmetaData;

        return response()->json([
            'success' => true,
            'sessionDetailsData' => [
                'id' => $track->id,
                'track_title' => $track->track_title,
                'track_icon' => $track->track_icon,
                'cms_img' => $track->cms_img,
                'alias_title' => $track->alias_title,
                'track_desc' => $track->track_desc,
                'subtracks' => $track->subtracks->toArray(),
            ],
            'meta' => $meta ? (array) $meta : []
        ]);
    }
}