<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Conference;
use Illuminate\Http\JsonResponse;

class AboutUsApiController extends Controller
{
    public function show($id): JsonResponse
    {
        $conference = Conference::with(['aboutUsItems', 'AboutmetaData'])->find($id);

        if (!$conference) {
            return response()->json([
                'success' => false,
                'message' => 'Conference not found'
            ], 404);
        }

        $meta = $conference->AboutmetaData;

        return response()->json([
            'success' => true,
            'aboutUsData' => $conference->aboutUsItems,
            'meta' => [
                'title' => $meta->meta_title ?? 'About Us – Conference',
                'description' => $meta->meta_description ?? 'Learn about our mission, vision, and why you should attend.',
                'keywords' => $meta->meta_keywords ?? 'about us, conference, mission, vision'
            ]
        ]);
    }
}