<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Api\ConferenceApiController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\ContactApiController;
use App\Http\Controllers\Api\MediaPartnersController;
use App\Http\Controllers\Api\AbstractSubmissionApiController;
use App\Http\Controllers\Api\BrochureApiController;
use App\Http\Controllers\Api\ThankYouApiController;
use App\Http\Controllers\Api\ConferenceBookApiController;
use App\Http\Controllers\Api\AllSpeakersApiController;
use App\Http\Controllers\Api\SpeakersPageApiController;
use App\Http\Controllers\Api\SpeakersListApiController;
use App\Http\Controllers\Api\SpeakerDetailsApiController;
use App\Http\Controllers\Api\CallForPapersApiController;
use App\Http\Controllers\Api\PreviousSpeakersApiController;
use App\Http\Controllers\Api\VenueApiController;
use App\Http\Controllers\Api\HomepageApiController;
use App\Http\Controllers\Api\RegistrationApiController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\StripeController;
use App\Http\Controllers\Api\AboutUsApiController;
use App\Http\Controllers\Api\ScientificCommitteeApiController;

use App\Http\Controllers\Api\SubscriptionApiController;
use App\Http\Controllers\Api\ProgramScheduleApiController;
use App\Http\Controllers\Api\SponsorsExhibitorsApiController;
use App\Http\Controllers\Api\ScientificProgramApiController;

use App\Http\Controllers\Api\ProgramDetailsApiController;
use App\Http\Controllers\Api\SponsorshipApiController;
use App\Http\Controllers\Api\SponsorshipThankYouApiController;

use App\Http\Controllers\Api\ConferenceGalleryApiController;
use App\Http\Controllers\Api\PresentationSubmissionApiController;
use App\Http\Controllers\Api\VenueV1ApiController;

use App\Http\Controllers\Api\PaypalApiController;
use App\Http\Controllers\OnlineRegistrationController;

use App\Http\Controllers\Api\OnlineRegistrationApiController;
use App\Http\Controllers\Api\OnlinePaypalApiController;
use App\Http\Controllers\Api\GroupRegistrationApiController;
use App\Http\Controllers\Api\ConferenceRegistrationController;
use App\Http\Controllers\Api\XyzRegistrationController;
use App\Http\Controllers\Api\XyzPaypalController;
use App\Http\Controllers\Api\StripeLatestController;
Route::get('/clear-cache', function() {
    \Artisan::call('config:clear');
    \Artisan::call('cache:clear');
    \Artisan::call('config:cache');
    return "Cache cleared!";
});

Route::post('/lateststripe/latestcreate-checkout', [StripeLatestController::class, 'latestcreateCheckout']);
Route::get('/latest/registrationv4/stripe/payment-success-v4/{sessionId}', [StripeLatestController::class, 'stripeSuccess']);




Route::get('/asset/{id}/{filename}', function ($id, $filename) {
    $path = "conferences/{$id}/{$filename}";
    if (!Storage::disk('public')->exists($path)) {
        abort(404);
    }
    return Storage::disk('public')->response($path);
});

Route::get('/conferences', [ConferenceApiController::class, 'index']);
Route::get('/conference/{id}', [ConferenceApiController::class, 'show']);
Route::get('/common/{id}', [ConferenceApiController::class, 'common']);
Route::get('/page/contact/{id}', [ContactApiController::class, 'pageData']);
Route::get('/page/mediapartners/{id}', [MediaPartnersController::class, 'pageData']);
Route::get('/page/abstract/{id}', [AbstractSubmissionApiController::class, 'show']);
Route::post('/abstract-submission', [AbstractSubmissionApiController::class, 'store']);
Route::get('/phonecode/{id}', [AbstractSubmissionApiController::class, 'getPhonecode']);
Route::get('/page/about-us/{id}', [AboutUsApiController::class, 'show']);
Route::post('/contact', [ContactController::class, 'store']);
Route::get('/page/brochure/{id}', [BrochureApiController::class, 'show']);
Route::post('/brochure', [BrochureApiController::class, 'store']);
Route::get('/brochure/{id}', [BrochureApiController::class, 'show']);
Route::get('/page/thankyou/{id}', [ThankYouApiController::class, 'show']);
Route::get('/page/conferencebook/{id}', [ConferenceBookApiController::class, 'show']);
Route::get('/page/allspeakers/{id}', [AllSpeakersApiController::class, 'show']);
Route::get('/page/speakers/{id}', [SpeakersPageApiController::class, 'show']);
Route::get('/page/speakers-list/{id}', [SpeakersListApiController::class, 'show']);
Route::get('/page/speakerdetails/{id}/{alias_name?}', [SpeakerDetailsApiController::class, 'show']);
Route::get('/page/callforpapers/{id}', [CallForPapersApiController::class, 'index']);
Route::get('/page/sessiondetails/{id}/{alias_name}', [CallForPapersApiController::class, 'show']);
Route::get('/page/previousspeakers/{id}', [PreviousSpeakersApiController::class, 'index']);
Route::get('/page/venue/{id}', [VenueApiController::class, 'index']);
Route::get('/page/home/{id}', [HomepageApiController::class, 'index']);
Route::get('/page/indexv1/{id}', [HomepageApiController::class, 'indexv1']);
Route::get('/registration/{id}/{currency?}', [RegistrationApiController::class, 'index']);
Route::post('/register', [RegistrationApiController::class, 'submit']);
//Route::post('/payment/success', [PaymentController::class, 'success']);
Route::post('/stripe/checkout', [App\Http\Controllers\Api\StripeController::class, 'createCheckout']);
Route::get('/page/media-partner/{id}/{alias}', [MediaPartnersController::class, 'showDetail']);
Route::get('/page/subscribe/{id}', [SubscriptionApiController::class, 'show']);
Route::post('/page/subscribe/{id}', [SubscriptionApiController::class, 'subscribe']);
Route::post('/page/unsubscribe/{id}', [SubscriptionApiController::class, 'unsubscribe']);
Route::get('/page/scientific-committee/{id}', [ScientificCommitteeApiController::class, 'show']);
Route::get('/page/sponsors-exhibitors/{id}', [SponsorsExhibitorsApiController::class, 'show']);
Route::get('/page/program-schedule/{id}', [ProgramScheduleApiController::class, 'show']);
Route::get('/page/program-details/{id}/{alias_name}', [ProgramDetailsApiController::class, 'show']);
Route::get('/page/scientific-program/{id}', [ScientificProgramApiController::class, 'show']);
Route::get('/page/conference-gallery/{id}', [ConferenceGalleryApiController::class, 'index']);
Route::get('/page/conference-gallery/{id}/{alias_name}', [ConferenceGalleryApiController::class, 'show']);
Route::get('/page/sponsorship/{id}', [SponsorshipApiController::class, 'show']);
Route::post('/page/sponsorship/{id}', [SponsorshipApiController::class, 'submit']);
Route::get('/page/sponsorship-thank-you/{id}', [SponsorshipThankYouApiController::class, 'show']);
Route::get('/page/presentation-submission/{id}', [PresentationSubmissionApiController::class, 'show']);
Route::post('/page/presentation-submission/{id}', [PresentationSubmissionApiController::class, 'submit']);
Route::get('/page/venue-v1/{id}', [VenueV1ApiController::class, 'show']);

Route::post('/payment/create-intent', [RegistrationApiController::class, 'createPaymentIntent']);
Route::post('/payment/success', [RegistrationApiController::class, 'paymentSuccess']);
Route::get('/payment/success/{order_id}', [RegistrationApiController::class, 'getPaymentSuccessData']);
Route::post('/payment/success/{order_id}', [RegistrationApiController::class, 'updatePaymentSuccess']);


// routes/web.php

Route::get('/paypal/summary/{orderId}', [RegistrationApiController::class, 'summary']);

// Called by PayPal after payment (user redirected)
Route::get('/payment/return', [PaypalApiController::class, 'returnFromPayPal']);

// Called by PayPal silently (Instant Payment Notification)
Route::post('/payment/ipn', [PaypalApiController::class, 'handleIPN'])->name('paypal.ipn');

// Called by Vue to get success data
Route::get('/payment/paypalsuccess/{order_id}', [PaypalApiController::class, 'getSuccessData']);

// Cancel
Route::get('/payment/cancel', function () {
    return redirect('/registration?error=payment_cancelled');
});

// ---------- ONLINE REGISTRATION ----------
// Online Registration API
Route::get('/online-registration/{conferenceId}/{currency?}', [OnlineRegistrationApiController::class, 'index']);
Route::post('/online-registration/register', [OnlineRegistrationApiController::class, 'submit']); // ✅ Fixed

// PayPal return
Route::get('/online-payment/return', [OnlinePaypalApiController::class, 'returnFromPayPal']);
Route::get('/online-payment/success/{order_id}', [OnlinePaypalApiController::class, 'getSuccessData']);


Route::get('/countries/{name}/code', [RegistrationApiController::class, 'getPhoneCode']);

Route::get('/register/init', [RegistrationApiController::class, 'init']);




Route::get('/online-registration/{conferenceId?}', [OnlineRegistrationController::class, 'init']);
Route::get('/paypal/summary/{orderId}', [OnlineRegistrationController::class, 'paypalSummary']);
Route::get('/stripe/summary/{orderId}', [OnlineRegistrationController::class, 'stripeSummary']);




// Online Registration Init
Route::get('/online/register/init', [OnlineRegistrationApiController::class, 'init']);
Route::get('/online/countries/{country}/code', [OnlineRegistrationApiController::class, 'countryCode']);

// Checkout

// Success summary
Route::get('/online/payment/success/{order_id}', [OnlineRegistrationApiController::class, 'summary']);

// PayPal routes
Route::get('/online/paypal/summary/{orderId}', [OnlineRegistrationApiController::class, 'summary']);
Route::get('/online/payment/return', [OnlinePaypalApiController::class, 'returnFromPayPal']);
Route::post('/online/payment/ipn', [OnlinePaypalApiController::class, 'handleIPN'])->name('online.paypal.ipn');
Route::get('/online/payment/paypalsuccess/{order_id}', [OnlinePaypalApiController::class, 'getSuccessData']);




Route::get('/group/init', [GroupRegistrationApiController::class, 'init']);
Route::post('/group/checkout', [GroupRegistrationApiController::class, 'checkout']);
Route::get('/group/success/{orderId}', [GroupRegistrationApiController::class, 'getSuccessData']);


// Group Registration APIs
Route::post('/group/register', [GroupRegistrationApiController::class, 'register']);
Route::post('/group/payment/create-intent', [GroupRegistrationApiController::class, 'createPaymentIntent']);
Route::post('/group/payment/success', [GroupRegistrationApiController::class, 'paymentSuccess']);
Route::get('/group/payment/success/{order_id}', [GroupRegistrationApiController::class, 'getPaymentSuccessData']);
Route::post('/group/payment/success/{order_id}', [GroupRegistrationApiController::class, 'updatePaymentSuccess']);

// PayPal related
Route::get('/group/paypal/summary/{orderId}', [GroupRegistrationApiController::class, 'summary']);
Route::get('/group/payment/return', [PaypalApiController::class, 'returnFromPayPal']);
Route::post('/group/payment/ipn', [PaypalApiController::class, 'handleIPN'])->name('group.paypal.ipn');
Route::get('/group/payment/paypalsuccess/{order_id}', [PaypalApiController::class, 'getGroupSuccessData']);
Route::get('/group/payment/cancel', function () {
    return redirect('/group-registration?error=payment_cancelled');
});


Route::post('/checkout-online', [ConferenceRegistrationController::class, 'checkoutOnline']);
Route::post('/stripe-payment-success', [ConferenceRegistrationController::class, 'stripePaymentSuccess']);
Route::post('/paypal-ipn', [ConferenceRegistrationController::class, 'handlePayPalIPN']);
Route::get('/success-details/{userId}', [ConferenceRegistrationController::class, 'getSuccessDetails']);
//Route::get('/conference/{id}', [ConferenceRegistrationController::class, 'getConferenceData']);
Route::post('/paypal/url', [ConferenceRegistrationController::class, 'getPayPalUrl']);

Route::get('/xyzpage/xyz-online-registration/{id}', [XyzRegistrationController::class, 'index'])->name('xyz.online-registration');
Route::post('/xyzregistration/submit', [XyzRegistrationController::class, 'submit'])->name('xyz.registration.submit');
Route::post('/xyzpayment/create-intent', [XyzRegistrationController::class, 'createPaymentIntent'])->name('xyz.payment.create-intent');
Route::post('/xyzpayment/success/{order_id}', [XyzRegistrationController::class, 'updatePaymentSuccess'])->name('xyz.payment.success');
Route::get('/xyzsuccess-details/{order_id}', [XyzRegistrationController::class, 'getSuccessData'])->name('xyz.success-details');
Route::post('/xyzgetPhoneCode', [XyzRegistrationController::class, 'getPhoneCode'])->name('xyz.getPhoneCode');
Route::get('/xyzreceipt/{id}', [XyzRegistrationController::class, 'getReceipt'])->name('xyz.receipt'); // Assumed endpoint
Route::post('/xyzpaypal/ipn', [XyzPaypalController::class, 'handleIPN'])->name('xyz.paypal.ipn');
Route::get('/xyzpaypal/success-data/{orderId}', [XyzPaypalController::class, 'getSuccessData'])->name('xyz.paypal.success-data');
Route::any('/xyzpaypal/return', [XyzPaypalController::class, 'returnFromPayPal'])->name('xyz.paypal.return');



// v4 Registration
Route::prefix('registrationv4')->group(function () {
    Route::get('/{id}/{currency?}', [App\Http\Controllers\Api\RegistrationApiController::class, 'indexV4']);
    Route::post('/submit', [App\Http\Controllers\Api\RegistrationApiController::class, 'submitV4']);
    Route::post('/create-payment-intent', [App\Http\Controllers\Api\RegistrationApiController::class, 'createPaymentIntentV4']);
    Route::post('/update-payment-success/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'updatePaymentSuccessV4']);
    Route::get('/payment-success-v4/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'getPaymentSuccessDataV4']);
        Route::get('/paypal/payment-success-v4/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'getPaymentSuccessDataV4']);

    Route::get('/summary/{order_id}', [App\Http\Controllers\Api\RegistrationApiController::class, 'summaryV4']);
    Route::get('/init', [App\Http\Controllers\Api\RegistrationApiController::class, 'initV4']);
    Route::get('/get/phone-code/{name}', [App\Http\Controllers\Api\RegistrationApiController::class, 'getPhoneCodeV4']);
        Route::get('/payment/stripe/return', [App\Http\Controllers\Api\RegistrationApiController::class, 'stripeReturnV4']);

});

// v4 PayPal
Route::prefix('paypalv4')->group(function () {
    Route::get('/return', [App\Http\Controllers\Api\PaypalApiController::class, 'returnFromPayPalvfour']);
    Route::post('/ipn', [App\Http\Controllers\Api\PaypalApiController::class, 'handleIPNV4']);
    Route::get('/successvfour/{order_id}', [App\Http\Controllers\Api\PaypalApiController::class, 'getSuccessDataV4']);
});

// Group Registration v5
Route::prefix('groupv5')->group(function () {
    Route::get('/{id}/{currency?}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'indexV5']);
    Route::post('/submit', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'submitV5']);

    // Stripe
    Route::post('/create-payment-intent', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'createPaymentIntentV5']);
    Route::get('/payment/stripe/return', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'stripeReturnV5']);

    // Success payloads
    Route::get('/stripe/payment-success-v5/{order_id}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'getPaymentSuccessDataV5']);
    Route::get('/summary/{order_id}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'summaryV5']);

    // Utility
    Route::get('/get/phone-code/{name}', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'getPhoneCodeV5']);
});

// PayPal IPN (v5)
Route::prefix('paypalv5')->group(function () {
    Route::post('/ipn', [App\Http\Controllers\Api\GroupRegistrationApiController::class, 'paypalIpnV5']);
});

Route::get('/conference/by-path/get', [ConferenceApiController::class, 'findByPath']);