<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserRegistrationDate extends Model
{
    protected $table = 'c_user_registrations_dates';
    public $timestamps = false;

    protected $fillable = [
        'order_id', 'user_id', 'earlyType', 'registration_id', 'reg_qty',
        'reg_total_amount', 'total_amount', 'curency_type', 'payment_meathod',
        'reg_date', 'created_date', 'payment_status'
    ];

    public function registration()
    {
        return $this->belongsTo(Registration::class, 'user_id');
    }
    
     public function addonAmounts()
    {
        return $this->hasMany(UserAddonAmount::class, 'reg_id');
    }
}