<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserAddonAmount extends Model
{
    protected $table = 'c_user_addon_amounts';
    public $timestamps = false;

    protected $fillable = [
        'order_id', 'user_id', 'reg_id', 'addon_catid', 'addon_subcatid',
        'addon_qty', 'addon_amount', 'addon_total_amount', 'currency_type',
        'reg_date', 'created_date'
    ];

    public function userRegistrationDate()
    {
        return $this->belongsTo(UserRegistrationDate::class, 'reg_id');
    }
}