<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StripeSession extends Model
{
    protected $table = 'stripe_sessions';
    public $timestamps = false;

    protected $fillable = [
        'session_id', 'order_id', 'conference_id', 'user_name', 'user_email',
        'amount', 'currency', 'status', 'created_at'
    ];

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}