<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SponsorsContent extends Model
{
    protected $table = 'c_sponsors_content';
    public $timestamps = false;

    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if ($this->cms_img && $this->conference) {
            $base = "https://scisynopsisconferences.com/uploads/conferences";
            return "{$base}/{$this->conference->unique_id}/" . urlencode($this->cms_img);
        }
        return null;
    }

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}