<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SocialLink extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'c_social';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * Get the conference that owns the social link.
     */
    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }
}