<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegistrationShipping extends Model
{
    protected $table = 'c_registration_shipping';
    public $timestamps = false;

    protected $fillable = [
        'regid', 'conference_id', 'shipDesign', 'shipFirstname', 'shipLastname',
        'shipCompany', 'shipCountry', 'shipEmail', 'shipPhone', 'shipWhatsapp',
        'shipAddress', 'createDate'
    ];

    public function registration()
    {
        return $this->belongsTo(Registration::class, 'regid');
    }
}