<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Registration extends Model
{
    protected $table = 'c_reg_users';
    public $timestamps = false;

    protected $fillable = [
        'conference_id', 'designation', 'firstname', 'lastname', 'usr_email',
        'country', 'country_code', 'user_phone', 'usr_whatsapp', 'company',
        'category', 'address', 'user_type', 'currency', 'payment_method',
        'total_amount', 'created_date', 'payment_status', 'transaction_id', 'abstract_title','coupon_value','invoiceid','aditional_details','extra_info',
        'total_extra_amount'
    ];

    public function conference()
    {
        return $this->belongsTo(Conference::class, 'conference_id');
    }

    public function shipping()
    {
        return $this->hasOne(RegistrationShipping::class, 'regid');
    }

    public function groupRegistrationDate()
    {
        return $this->hasOne(GroupRegistrationDate::class, 'user_id');
    }
    
     public function userRegistrationDate()
    {
        return $this->hasOne(UserRegistrationDate::class, 'user_id');
    }
    
     public function payment()
    {
        return $this->hasOne(Payment::class, 'order_id', 'id');
    }
}