<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GalleryItem extends Model
{
    protected $table = 'previous_conference_gallery';
    public $timestamps = false;

    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if ($this->gallery_img) {
            $base = "https://scisynopsisconferences.com/uploads/gallery";
            return "{$base}/{$this->gallery_img}";
        }
        return null;
    }

    public function parent()
    {
        return $this->belongsTo(self::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(self::class, 'parent_id');
    }
}