<?php

namespace App\Http\Controllers\Api;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SponsorshipThankYouApiController extends Controller
{
    public function show($id)
    {
        $conference = DB::table('conferences')->find($id);
        if (!$conference) {
            return response()->json(['success' => false, 'message' => 'Conference not found'], 404);
        }

        $uploadsBase = "https://scisynopsisconferences.com/uploads/conferences";

        // Get brochure (page_type = 12 = Sponsorship Brochure)
        $brochure = DB::table('c_brouchers')
            ->where([
                'conference_id' => $id,
                'page_type' => 12,
                'status' => 1
            ])
            ->first();

        $brochureUrl = $brochure?->brouchure_name
            ? "{$uploadsBase}/{$conference->unique_id}/" . urlencode($brochure->brouchure_name)
            : null;

        // Meta
        $metaRecord = DB::table('c_meta_data')
            ->where(['conference_id' => $id, 'page_type' => 33])
            ->first();

        return response()->json([
            'success' => true,
            'sponsorshipThankYouData' => compact('brochure', 'brochureUrl'),
            'meta' => [
                'title' => $metaRecord->meta_title ?? 'Thank You – Sponsorship Download',
                'description' => 'Thank you for downloading the sponsorship brochure.',
                'keywords' => 'thank you, sponsorship, download, brochure'
            ]
        ]);
    }
}